/*jslint vars: true, plusplus: true, devel: true, nomen: true, regexp: true, indent: 4, maxerr: 50 */
/*global $, window, location, CSInterface, SystemPath, themeManager*/

var csInterface = new CSInterface();

function Persistent(inOn) {
    var event;
    if (inOn) {
        event = new CSEvent("com.adobe.PhotoshopPersistent", "APPLICATION");
    } else {
        event = new CSEvent("com.adobe.PhotoshopUnPersistent", "APPLICATION");
    }
    event.extensionId = "org.54ka.colordream.apps";
    csInterface.dispatchEvent(event);
}

Persistent(true);

(function () {
    'use strict';

    var csInterface = new CSInterface();

    function init() {
                    
            themeManager.init();

            function protectKey() {

                var retrievedData = localStorage.getItem("colorDreamLicenseKey");
                if(retrievedData) {
                        var myValue = JSON.parse(retrievedData);
                        var passKey = myValue.licenseKey;

                        csInterface.evalScript('lockAppPassKey("'+passKey+'")', function f(x) { 
                                if (x === "1") {
                                    $("#wrap_Register").attr("style", "display: none;");
                                    $("#wrap_ButtonsApp").attr("style", "display: block;");
                                } else {
                                    $("#wrap_Register").attr("style", "display: block;");
                                    activationProcess();
                                }
                        });

                } else {
                    $("#wrap_Register").attr("style", "display: block;");
                    activationProcess();
                }

            }

            protectKey();

            function activationProcess() {
                $("#sendKey").click(function () {
                    var myKey = $("#keyTextArea").val();
                    var myValue = ({licenseKey: myKey});
                    localStorage.setItem("colorDreamLicenseKey", JSON.stringify(myValue));
                    protectKey();
                });
            }

            $("#main_btn").click(function () {

                var option = $("#intensity").attr("data");

                if($("#curves").attr("data") === "true") { var colCurves = option } else { var colCurves = 0};
                if($("#colorBalance").attr("data") === "true") { var colBalance = option } else { var colBalance = 0};
                if($("#selectiveColor").attr("data") === "true") { var selColor = option } else { var selColor = 0};
                if($("#gradient").attr("data") === "true") { var gradientM = option } else { var gradientM = 0};
                if($("#colorLookup").attr("data") === "true") { var cLookup = option } else { var cLookup = 0};
                if($("#levels").attr("data") === "true") { var aLevels = option } else { var aLevels = 0};

                csInterface.evalScript('main54kaColorFunction(), curves_AdjLayer('+colCurves+'), colorBalance_AdjLayer('+colBalance+'), selectiveColors_AdjLayer('+selColor+'), gradientMap_AdjLayer('+gradientM+'), colorLookup_AdjLayer('+cLookup+'), levels_AdjLayer('+aLevels+')');

            });

            $("#levels").click(function () {
                var x = $("#levels").attr("data");
                if(x === "true") {
                    $("#levels").attr("data", "false");
                    $("#levels").removeClass("isOn");
                } else {
                    $("#levels").attr("data", "true");
                    $("#levels").addClass( "isOn" );
                }
            });

            $("#colorLookup").click(function () {
                var x = $("#colorLookup").attr("data");
                if(x === "true") {
                    $("#colorLookup").attr("data", "false");
                    $("#colorLookup").removeClass("isOn");
                } else {
                    $("#colorLookup").attr("data", "true");
                    $("#colorLookup").addClass( "isOn" );
                }
            });

            $("#gradient").click(function () {
                var x = $("#gradient").attr("data");
                if(x === "true") {
                    $("#gradient").attr("data", "false");
                    $("#gradient").removeClass("isOn");
                } else {
                    $("#gradient").attr("data", "true");
                    $("#gradient").addClass( "isOn" );
                }
            });

            $("#selectiveColor").click(function () {
                var x = $("#selectiveColor").attr("data");
                if(x === "true") {
                    $("#selectiveColor").attr("data", "false");
                    $("#selectiveColor").removeClass("isOn");
                } else {
                    $("#selectiveColor").attr("data", "true");
                    $("#selectiveColor").addClass( "isOn" );
                }
            });

            $("#colorBalance").click(function () {
                var x = $("#colorBalance").attr("data");
                if(x === "true") {
                    $("#colorBalance").attr("data", "false");
                    $("#colorBalance").removeClass("isOn");
                } else {
                    $("#colorBalance").attr("data", "true");
                    $("#colorBalance").addClass( "isOn" );
                }
            });

            $("#curves").click(function () {
                var x = $("#curves").attr("data");
                if(x === "true") {
                    $("#curves").attr("data", "false");
                    $("#curves").removeClass("isOn");
                } else {
                    $("#curves").attr("data", "true");
                    $("#curves").addClass( "isOn" );
                }
            });

            $("#value_1").click(function () {
                $("#intensity").attr("data", "1");
                $(".myValueButton").removeClass("isOn");
                $("#value_1").addClass( "isOn" );
            });

            $("#value_2").click(function () {
                $("#intensity").attr("data", "2");
                $(".myValueButton").removeClass("isOn");
                $("#value_2").addClass( "isOn" );
            });

            $("#value_3").click(function () {
                $("#intensity").attr("data", "3");
                $(".myValueButton").removeClass("isOn");
                $("#value_3").addClass( "isOn" );
            });

            $("#levels1").click(function () {
                $(".myButton").removeClass("isOn");
                $(".myButton").attr("data", "false");
                $("#levels").addClass( "isOn" );
                $("#levels").attr("data", "true");
            });

            $("#colorLookup1").click(function () {
                $(".myButton").removeClass("isOn");
                $(".myButton").attr("data", "false");
                $("#colorLookup").addClass( "isOn" );
                $("#colorLookup").attr("data", "true");
            });

            $("#gradient1").click(function () {
                $(".myButton").removeClass("isOn");
                $(".myButton").attr("data", "false");
                $("#gradient").addClass( "isOn" );
                $("#gradient").attr("data", "true");
            });

            $("#selectiveColor1").click(function () {
                $(".myButton").removeClass("isOn");
                $(".myButton").attr("data", "false");
                $("#selectiveColor").addClass( "isOn" );
                $("#selectiveColor").attr("data", "true");
            });

            $("#colorBalance1").click(function () {
                $(".myButton").removeClass("isOn");
                $(".myButton").attr("data", "false");
                $("#colorBalance").addClass( "isOn" );
                $("#colorBalance").attr("data", "true");
            });

            $("#curves1").click(function () {
                $(".myButton").removeClass("isOn");
                $(".myButton").attr("data", "false");
                $("#curves").addClass( "isOn" );
                $("#curves").attr("data", "true");
            });

    }
        
    init();

}());
    
