/*jslint vars: true, plusplus: true, devel: true, nomen: true, regexp: true, indent: 4, maxerr: 50 */
/*global $, window, location, CSInterface, SystemPath, themeManager*/

/////////////////////////////////////////////////////////////////////////////
// Tell Photoshop to NOT UNLOAD!!! us when closed
// Get a reference to a CSInterface object
var csInterface = new CSInterface();

function Persistent(inOn) {
    var event;
    if (inOn) {
        event = new CSEvent("com.adobe.PhotoshopPersistent", "APPLICATION");
    } else {
        event = new CSEvent("com.adobe.PhotoshopUnPersistent", "APPLICATION");
    }
    event.extensionId = "org.54ka.cropper.apps";
    csInterface.dispatchEvent(event);
}
Persistent(true);

/////////////////////////////////////////////////////////////////////////////

(function () {
    'use strict';

    var csInterface = new CSInterface();

    function init() {

        themeManager.init();

        /////////////////////////////////////////////////////////////////////////////

        $(".preDef").click(function () {
            var val = this.innerText;
            var res = val.split(':');
            
            $("#customRatioWidth").val(res[0]);
            $("#customRatioHeight").val(res[1]);
        });

        $("#switchValues").click(function () {
            var w = $("#customRatioWidth").val();
            var h = $("#customRatioHeight").val();

            $("#customRatioWidth").val(h);
            $("#customRatioHeight").val(w);
        });

        // Custom Ratio
        $("#executeNewRatio").click(function () {
            var ws = $("#customRatioWidth").val();
            var hs = $("#customRatioHeight").val();
            csInterface.evalScript('canvasCrop(' + ws + ', ' + hs + ')');
        });

        /////////////////////////////////////////////////////////////////////////////

    }

    init();

}());